Imports System.ComponentModel

Public Class PhoneSSN

  Inherits System.Windows.Forms.UserControl

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'UserControl1 overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents txtAreaCode As System.Windows.Forms.TextBox
  Friend WithEvents txtExchange As System.Windows.Forms.TextBox
  Friend WithEvents txtNumber As System.Windows.Forms.TextBox
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.txtAreaCode = New System.Windows.Forms.TextBox()
    Me.txtExchange = New System.Windows.Forms.TextBox()
    Me.txtNumber = New System.Windows.Forms.TextBox()
    Me.SuspendLayout()
    '
    'txtAreaCode
    '
    Me.txtAreaCode.Location = New System.Drawing.Point(8, 8)
    Me.txtAreaCode.Name = "txtAreaCode"
    Me.txtAreaCode.Size = New System.Drawing.Size(40, 20)
    Me.txtAreaCode.TabIndex = 0
    Me.txtAreaCode.Text = ""
    '
    'txtExchange
    '
    Me.txtExchange.Location = New System.Drawing.Point(48, 8)
    Me.txtExchange.Name = "txtExchange"
    Me.txtExchange.Size = New System.Drawing.Size(40, 20)
    Me.txtExchange.TabIndex = 1
    Me.txtExchange.Text = ""
    '
    'txtNumber
    '
    Me.txtNumber.Location = New System.Drawing.Point(88, 8)
    Me.txtNumber.Name = "txtNumber"
    Me.txtNumber.Size = New System.Drawing.Size(48, 20)
    Me.txtNumber.TabIndex = 2
    Me.txtNumber.Text = ""
    '
    'ctlPhoneSSN
    '
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtNumber, Me.txtExchange, Me.txtAreaCode})
    Me.Name = "ctlPhoneSSN"
    Me.Size = New System.Drawing.Size(144, 40)
    Me.ResumeLayout(False)

  End Sub

#End Region

  '============ The data members ============

  ' The different formats available
  Enum Selection
    Phone = 0
    SSN
  End Enum

  ' Private members
  Private mBoxType As Selection     ' Do they want a Phone or SSN #?
  Private mAreaCode As String       ' The area code
  Private mExchange As String       ' The exchange
  Private mNumber As String         ' The rest of the number
  Private mComplete As String       ' The complete string

  '============ The property procedures ============

  '                     InputType()

  <Description("Will you enter phone numbers or Zip codes?"), _
  Category("Behavior")> _
  Property InputType() As Selection
    Get
      Return mBoxType
    End Get
    Set(ByVal Value As Selection)
      mBoxType = Value
    End Set
  End Property

  '                     AreaCode()

  <Description("The area code or first three digits of SSN.")> _
   Property AreaCode() As String
    Get
      Return Me.txtAreaCode.Text
    End Get
    Set(ByVal Value As String)
      Me.txtAreaCode.Text = Value
    End Set
  End Property

  '                     Exchange() 
  <Description("The phone exchange or middle two digits of SSN.")> _
   Property Exchange() As String
    Get
      Return Me.txtExchange.Text
    End Get
    Set(ByVal Value As String)
      Me.txtExchange.Text = Value
    End Set
  End Property

  '                     Number() 
  <Description("The last four digits of phone number or SSN.")> _
   Property Number() As String
    Get
      Return Me.txtNumber.Text
    End Get
    Set(ByVal Value As String)
      Me.txtNumber.Text = Value
    End Set
  End Property

  '                     Complete()
  <Description("A complete phone number or SSN.")> _
   Property Complete() As String
    Get
      If mBoxType = Selection.Phone Then
        mComplete = "(" & Me.txtAreaCode.Text & ")  " & Me.txtExchange.Text & "-" & Me.txtNumber.Text
      Else
        mComplete = Me.txtAreaCode.Text & "-" & Me.txtExchange.Text & "-" & Me.txtNumber.Text
      End If
      Return mComplete
    End Get
    Set(ByVal Value As String)
      Me.txtNumber.Text = Value
    End Set
  End Property


  '============ Class methods ============

  ' These constants are derived by taking the ratio of box width to the
  ' control width. This is a little bit of ugliness, but it works.
  Private Const TWODIGITS As Single = 0.19
  Private Const THREEDIGITS As Single = 0.238
  Private Const FOURDIGITS As Single = 0.286

  Protected Overrides Sub OnFontChanged(ByVal e As System.EventArgs)
    MyBase.OnFontChanged(e)
    ResizeFieldBoxes()
  End Sub

  Private Sub PhoneSSNTextBox_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Resize
    ResizeFieldBoxes()
  End Sub

  Private Sub ResizeFieldBoxes()
    Dim ControlWidth As Integer = Me.ClientRectangle.Width
    Dim ControlHeight As Integer = Me.ClientRectangle.Height
    Dim TwoBox, ThreeBox, FourBox As Integer

    If ControlHeight < 24 Then        ' Set a minimum control height
      ControlHeight = 32
      Me.Height = 32
    End If

    If ControlWidth < 104 Then        ' Set a minimum control width
      ControlWidth = 104
      Me.Width = ControlWidth
    End If

    TwoBox = ControlWidth * TWODIGITS     ' Set relative sizes
    ThreeBox = ControlWidth * THREEDIGITS
    FourBox = ControlWidth * FOURDIGITS

    txtAreaCode.SetBounds(8, 8, ThreeBox, 0)

    If mBoxType = Selection.Phone Then
      txtExchange.SetBounds(ThreeBox + 8, 8, ThreeBox, 0)
      txtNumber.SetBounds(ThreeBox * 2 + 8, 8, FourBox, 0)
    Else
      txtExchange.SetBounds(ThreeBox + 8, 8, TwoBox, 0)
      txtNumber.SetBounds(ThreeBox + TwoBox + 8, 8, FourBox, 0)
    End If

  End Sub


End Class
